/*
 * Decompiled with CFR 0.152.
 */
package com.x310.clarity.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.commands.Command;
import net.minecraft.class_2172;

public class ChangeUsername
extends Command {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    public ChangeUsername() {
        super("changeusername", "Change the username with an access token.", new String[0]);
    }

    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> {
            this.info("Missing Arguments: changeusername <accessToken> <newUsername>", new Object[0]);
            return 1;
        });
        builder.then(ChangeUsername.argument((String)"accessToken", (ArgumentType)StringArgumentType.word()).then(ChangeUsername.argument((String)"username", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String accessToken = StringArgumentType.getString((CommandContext)context, (String)"accessToken");
            String username = StringArgumentType.getString((CommandContext)context, (String)"username");
            executor.execute(() -> {
                try {
                    String line;
                    URL url = new URL("https://api.minecraftservices.com/minecraft/profile/name/" + username);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Authorization", "Bearer " + accessToken);
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    int responseCode = connection.getResponseCode();
                    BufferedReader reader = null;
                    StringBuilder response = new StringBuilder();
                    reader = responseCode >= 400 ? new BufferedReader(new InputStreamReader(connection.getErrorStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    if (responseCode == 403) {
                        this.info("Name is already taken or Player is on username change delay.", new Object[0]);
                    } else if (responseCode == 400) {
                        this.info("Invalid profile name.", new Object[0]);
                    } else if (responseCode == 429) {
                        this.info("Too many requests.", new Object[0]);
                    } else if (responseCode == 200) {
                        this.info("Username changed to " + username + ".", new Object[0]);
                    } else {
                        this.info("Unexpected response code: " + responseCode + " | Response: " + response.toString(), new Object[0]);
                    }
                }
                catch (IOException e) {
                    this.error("Couldn't change username: " + e.getMessage(), new Object[0]);
                }
            });
            return 1;
        })));
    }
}

